#!/usr/bin/env python3
"""
Test cases for list comprehension examples

This module contains unit tests for the list comprehension examples.
"""

import unittest
from basic_examples import (
    squares, evens, fahrenheit_temps, multiplication_table, numbers,
    uppercase_greetings, number_categories, keys, unique_numbers, indexed_values
)
from advanced_examples import (
    flattened, cartesian_product, transposed, people, valid_numbers,
    adults, squared, sums, even_large_numbers
)

class TestBasicExamples(unittest.TestCase):
    def test_squares(self):
        self.assertEqual(squares, [0, 1, 4, 9, 16, 25, 36, 49, 64, 81])
    
    def test_evens(self):
        self.assertEqual(evens, [0, 2, 4, 6, 8, 10, 12, 14, 16, 18])
    
    def test_fahrenheit_temps(self):
        self.assertEqual(fahrenheit_temps, [32.0, 50.0, 68.0, 86.0, 104.0])
    
    def test_multiplication_table(self):
        self.assertEqual(multiplication_table[0], [1, 2, 3, 4, 5, 6, 7, 8, 9, 10])
        self.assertEqual(multiplication_table[9], [10, 20, 30, 40, 50, 60, 70, 80, 90, 100])
    
    def test_numbers(self):
        self.assertEqual(numbers, [0, 6, 12, 18, 24, 30, 36, 42, 48])
    
    def test_uppercase_greetings(self):
        self.assertEqual(uppercase_greetings, ['HELLO', 'WORLD', 'PYTHON', 'LIST', 'COMPREHENSION'])
    
    def test_number_categories(self):
        self.assertEqual(number_categories, ['even', 'odd', 'even', 'odd', 'even', 'odd', 'even', 'odd', 'even', 'odd'])
    
    def test_keys(self):
        self.assertEqual(keys, ['name', 'age', 'city'])
    
    def test_unique_numbers(self):
        self.assertEqual(unique_numbers, [1, 2, 3, 4, 5])
    
    def test_indexed_values(self):
        self.assertEqual(indexed_values, [(0, 'a'), (1, 'b'), (2, 'c'), (3, 'd')])

class TestAdvancedExamples(unittest.TestCase):
    def test_flattened(self):
        self.assertEqual(flattened, [1, 2, 3, 4, 5, 6, 7, 8, 9])
    
    def test_cartesian_product(self):
        self.assertEqual(len(cartesian_product), 9)
        self.assertIn(('red', 'S'), cartesian_product)
        self.assertIn(('blue', 'L'), cartesian_product)
    
    def test_transposed(self):
        self.assertEqual(transposed, [[1, 4, 7], [2, 5, 8], [3, 6, 9]])
    
    def test_people(self):
        self.assertEqual(len(people), 3)
        self.assertEqual(people[0], {'name': 'Alice', 'age': 25})
    
    def test_valid_numbers(self):
        self.assertEqual(valid_numbers, [1, 2, 4])
    
    def test_adults(self):
        self.assertEqual(adults, ['Alice', 'Charlie'])
    
    def test_squared(self):
        self.assertEqual(squared, [1, 4, 9, 16, 25])
    
    def test_sums(self):
        self.assertEqual(sums, [5, 7, 9])
    
    def test_even_large_numbers(self):
        self.assertEqual(len(even_large_numbers), 500)
        self.assertEqual(even_large_numbers[:5], [0, 2, 4, 6, 8])

if __name__ == '__main__':
    unittest.main()